-- * 1. This trigger is created for auto propagate the security of the folder for the type of
-- * dossier_projet_generral and dossier_projet_cours based on its etat_a value and the its subfolder
-- * of the type dossier_maitre. The acl policy was obtained from the objects in cabinet "/adminbibliotheque"
-- * of the type dossier_maitre_politique
-- * 2. Can be extented to more parent type other than dossier_projet_cours and dossier_projet_general
-- * 3. When create trigger, change to trigger name and on "table name" like "on  dossier_projet_cours_s" 
-- sp_settriggerorder  @triggername='nameReconstructWithVLabel', @order = 'first'
--sp_settriggerorder @triggername= 'nameReconstructWithVLabel', @order='first', @stmttype='INSERT'
--go 
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[autoPropagateDossierMaitreAclOnCompletedTrigger_cours]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
drop trigger autoPropagateDossierMaitreAclOnCompletedTrigger_cours
go
Create trigger autoPropagateDossierMaitreAclOnCompletedTrigger_cours
on  dossier_projet_cours_s
WITH ENCRYPTION
for update  
as  
if Update(etat_a)
  begin
  Declare @Insertedetatvalue nvarchar(32)  
  set @Insertedetatvalue = (select etat_a from inserted)  
  Declare @Insertedoid nvarchar(16)  
  set @Insertedoid = (select r_object_id from inserted)  
  Declare @policyparent_folder_type nvarchar(32)  
  set @policyparent_folder_type = (select [r_object_type] from dm_sysobject_s where r_object_id = @Insertedoid)  
  declare @newfolder_owner nvarchar (32)
-- check the adminbibliotheque cabinet has the policy to make sure the update of acl and owner are needed 
  if exists (select etat_politique from dossier_maitre_politique_s 
    where parent_dossier_status= @Insertedetatvalue
    and parent_folder_type = @policyparent_folder_type
    and etat_politique in (select [object_name] from dm_acl_s)
           and r_object_id in (select fs.r_object_id from dm_folder_s fs, 
         dm_folder_r fr where fs.r_object_id = 
      fr.r_object_id and fr.r_folder_path like 
     '/adminbibliotheque/%'))
  begin 
    declare @acl_name nvarchar(32)
    declare @acl_domain nvarchar(32)
    declare @childid nvarchar(16)
    declare @childobjname nvarchar(255)
    declare @childpolicyobjid nvarchar(16)
-- childcursor is declared for only the subfolder of type dossier_maitre under 
--     the parent folder of type documentation/dossier_project_cours and also only the subfolder that has acl etat policy
    declare childcursor cursor local for 
 select s.r_object_id, s.[object_name]
        from dm_sysobject_s s, dm_sysobject_r r 
        where s.r_object_id = r.r_object_id and r.i_folder_id = @Insertedoid and s.r_object_type = 'dossier_maitre'
     and s.[object_name] in (select dossier_maitre_nom from dossier_maitre_politique_s 
    where parent_dossier_status= @Insertedetatvalue
    and parent_folder_type = @policyparent_folder_type
    and etat_politique in (select [object_name] from dm_acl_s)
           and r_object_id in (select fs.r_object_id from dm_folder_s fs, 
         dm_folder_r fr where fs.r_object_id = 
      fr.r_object_id and fr.r_folder_path like 
     '/adminbibliotheque/%'))
    for read only
    open childcursor
    while (0=0) 
      begin
        fetch next from childcursor
        into @childid,@childobjname 
        if (@@fetch_status <> 0)
   begin
     break
   end
        else 
          begin
-- The following garantee the scale qry to return only one record under the specified folder path 
     set @childpolicyobjid = (select top 1 r_object_id from dossier_maitre_politique_s 
    where parent_dossier_status= @Insertedetatvalue
    and dossier_maitre_nom = @childobjname --@policydossier_maitre_nom
    and parent_folder_type = @policyparent_folder_type
           and r_object_id in (select fs.r_object_id from dm_folder_s fs, 
         dm_folder_r fr where fs.r_object_id = 
      fr.r_object_id and fr.r_folder_path like 
     '/adminbibliotheque/%')
  )
     set @acl_name = (select etat_politique from dossier_maitre_politique_s where r_object_id = @childpolicyobjid)
            set @acl_domain = (select top 1 owner_name from dm_acl_s where [object_name] = @acl_name)
       set @newfolder_owner = (select etat_ownership from dossier_maitre_politique_s where r_object_id = @childpolicyobjid)
     if exists (select '1' from dm_user_s where [user_name] = @newfolder_owner) 
     begin
----------------policy has owner valued ----------------
              update dm_sysobject_s
                set acl_name = @acl_name, 
                acl_domain = @acl_domain,
                owner_name = @newfolder_owner 
              where r_object_id = @childid
------------------
     end 
     else 
     begin
----------------policy has no owner value ----------------
              update dm_sysobject_s
                set acl_name = @acl_name, 
                acl_domain = @acl_domain
              where r_object_id = @childid
------------------
     end 
          end  -- end of if ... else for the cursor 
      end -- end of child object in cursor while loop 
  end -- end of if exist qry for necessary
---------------------------------------------------------------
-------------------------- now work with parent folder: 
set @newfolder_owner = null
declare @acl_name_parent nvarchar(32)
declare @acl_domain_parent nvarchar(32)
declare @insertedObjName nvarchar(27)
declare @parentpolicyobjid nvarchar(16)
set @insertedObjName = (select top 1 [object_name] from dm_sysobject_s where r_object_id = @Insertedoid)
set @parentpolicyobjid = (select top 1 r_object_id from dossier_maitre_politique_s 
    where parent_dossier_status= @Insertedetatvalue
    and dossier_maitre_nom = @insertedObjName --@policydossier_maitre_nom
    and parent_folder_type = @policyparent_folder_type
           and r_object_id in (select fs.r_object_id from dm_folder_s fs, 
         dm_folder_r fr where fs.r_object_id = 
      fr.r_object_id and fr.r_folder_path like 
     '/adminbibliotheque/%'))
set @acl_name_parent = (select top 1 etat_politique from dossier_maitre_politique_s where r_object_id = @parentpolicyobjid)
set @acl_domain_parent = (select top 1 owner_name from dm_acl_s where [object_name] = @acl_name_parent)
set @newfolder_owner = (select etat_ownership from dossier_maitre_politique_s where r_object_id = @parentpolicyobjid)
 
-- check the adminbibliotheque cabinet has the policy to make sure the update for parent folder of acl and owner are needed 
  if @acl_name_parent is not null  and @acl_domain_parent is not null  
  begin 
 if exists (select '1' from dm_user_s where [user_name] = @newfolder_owner) 
 begin
----------------policy has owner valued ----------------
            update dm_sysobject_s
              set acl_name = @acl_name_parent, 
              acl_domain = @acl_domain_parent,
              owner_name = @newfolder_owner 
            where r_object_id = @Insertedoid
------------------
 end 
 else 
 begin
----------------policy has no owner value ----------------
            update dm_sysobject_s
              set acl_name = @acl_name_parent, 
              acl_domain = @acl_domain_parent
            where r_object_id = @Insertedoid
------------------
 end 
  end -- end of if exist qry for parent folder update necessary 
 
end  -- end of if for the update(etat_a)
go
