<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="xml" version="1.0" encoding="ISO-8859-1" omit-xml-declaration ="no" indent="yes" 
	media-type="application/xml" />

<xsl:template match="/">
	<manifest identifier="MANIFEST1">
		<organizations default="TOC_1">
			<organization identifier="TOC_1" structure="hierarchical">
				<title><xsl:value-of select="cours/title"/></title>
				<xsl:for-each select="cours/node">
					<item>
						<xsl:attribute name="identifier">
							<xsl:number count="cours/node" format="A"/>
						</xsl:attribute>
						<xsl:attribute name="identifierref">
							<xsl:number count="cours/node" format="a"/>
						</xsl:attribute>
						<title><xsl:value-of select="current()/title" /></title>
						<object_id><xsl:number count="cours/node" format="001"/></object_id>
						<option>0</option>
					
					<xsl:for-each select="current()/module">
					<item>
						<xsl:attribute name="identifier">
							<xsl:number count="cours/node" format="A"/><xsl:number count="cours/node/module" format="001"/>
						</xsl:attribute>
						<xsl:attribute name="identifierref">
							<xsl:number count="cours/node" format="a"/><xsl:number count="cours/node/module" format="001"/>
						</xsl:attribute>
						<title><xsl:value-of select="current()/title" /></title>
						<object_id><xsl:number count="cours/node" format="a"/><xsl:number count="cours/node/module" format="001"/></object_id>
						<option>0</option>
					
						<xsl:for-each select="current()/lesson">
						<item>
							<xsl:attribute name="identifier">
								<xsl:number count="cours/node" format="A"/><xsl:number count="cours/node/module" format="001"/><xsl:number count="cours/node/module/lesson" format="i"/>
							</xsl:attribute>
							<xsl:attribute name="identifierref">
								<xsl:number count="cours/node" format="a"/><xsl:number count="cours/node/module" format="001"/><xsl:number count="cours/node/module/lesson" format="i"/>
							</xsl:attribute>
							<title><xsl:value-of select="current()/title" /></title>
							<object_id><xsl:number count="cours/node" format="a"/><xsl:number count="cours/node/module" format="001"/><xsl:number count="cours/node/module/lesson" format="i"/></object_id>
							<option>0</option>
						
							<xsl:for-each select="current()/item">
							<item>
								<xsl:attribute name="identifier">
									<xsl:number count="cours/node" format="A"/><xsl:number count="cours/node/module" format="001"/><xsl:number count="cours/node/module/lesson" format="i"/><xsl:number count="cours/node/module/lesson/item" format="a"/>
								</xsl:attribute>
								<xsl:attribute name="identifierref">
									<xsl:number count="cours/node" format="a"/><xsl:number count="cours/node/module" format="001"/><xsl:number count="cours/node/module/lesson" format="i"/><xsl:number count="cours/node/module/lesson/item" format="a"/>
								</xsl:attribute>
								<title><xsl:value-of select="current()/title" /></title>
								<object_id><xsl:number count="cours/node" format="a"/><xsl:number count="cours/node/module" format="001"/><xsl:number count="cours/node/module/lesson" format="i"/><xsl:number count="cours/node/module/lesson/item" format="a"/></object_id>
								<option>0</option>
							</item>
							</xsl:for-each>
							</item>
						</xsl:for-each>
						</item>
					</xsl:for-each>
					</item>
				</xsl:for-each>
			</organization>
		</organizations>
		<resources>
			<xsl:for-each select="cours/node">
					<resource>
						<xsl:attribute name="href">
							<xsl:value-of select="current()/path"/>
						</xsl:attribute>
						<xsl:attribute name="identifier">
							<xsl:number count="cours/node" format="a"/>
						</xsl:attribute>
						<xsl:attribute name="type">webcontent</xsl:attribute>
					</resource>
					<xsl:for-each select="current()/module">
						<resource>
							<xsl:attribute name="href">
								<xsl:value-of select="current()/path"/>
							</xsl:attribute>
							<xsl:attribute name="identifier">
								<xsl:number count="cours/node" format="a"/><xsl:number count="cours/node/module" format="001"/>
							</xsl:attribute>
							<xsl:attribute name="type">webcontent</xsl:attribute>
						</resource>
						<xsl:for-each select="current()/lesson">
							<resource>
								<xsl:attribute name="href">
									<xsl:value-of select="current()/path"/>
								</xsl:attribute>
								<xsl:attribute name="identifier">
									<xsl:number count="cours/node" format="a"/><xsl:number count="cours/node/module" format="001"/><xsl:number count="cours/node/module/lesson" format="i"/>
								</xsl:attribute>
								<xsl:attribute name="type">webcontent</xsl:attribute>
							</resource>
							<xsl:for-each select="current()/item">
								<resource>
									<xsl:attribute name="href">
										<xsl:value-of select="current()/path"/>
									</xsl:attribute>
									<xsl:attribute name="identifier">
										<xsl:number count="cours/node" format="a"/><xsl:number count="cours/node/module" format="001"/><xsl:number count="cours/node/module/lesson" format="i"/><xsl:number count="cours/node/module/lesson/item" format="a"/>
									</xsl:attribute>
									<xsl:attribute name="type">webcontent</xsl:attribute>
								</resource>
							</xsl:for-each>
						</xsl:for-each>
					</xsl:for-each>
				</xsl:for-each>
		</resources>
	</manifest>
</xsl:template>

</xsl:stylesheet>