// Special confirugation for pettier for this project. Creating this file is optional in a project.
module.exports = {
  root: true,
  env: {
    node: true,
    browser: true
  },
  plugins: ['prettier'],
  extends: [
    'plugin:vue/recommended',
    'eslint:recommended',
    'prettier',
    '@vue/prettier'
  ],
  rules: {
    // Only allow debugger in development
    'no-debugger': process.env.PRE_COMMIT ? 'error' : 'off',
    // Only allow `console.log` in development
    'no-console': process.env.PRE_COMMIT
      ? ['error', { allow: ['warn', 'error'] }]
      : 'off',
    'comma-dangle': ['error', 'never'],
    'no-alert': 'off',
    'vue/array-bracket-spacing': 'error',
    'vue/block-spacing': 'error',
    'vue/comma-dangle': ['error', 'never'],
    'vue/object-curly-spacing': ['error', 'always'],
    'vue/component-name-in-template-casing': [
      'error',
      'kebab-case',
      {
        ignores: []
      }
    ],
    'vue/no-v-html':'off',
    'prettier/prettier': [
      'error',
      { singleQuote: true, endOfLine: 'auto', semi: false }
    ],
    'no-param-reassign': [0, { allowPassedByValue: true }],
    'no-shadow': 'off',
    'prefer-const': [
      'off',
      {
        destructuring: 'any',
        ignoreReadBeforeAssign: false
      }
    ],
    'consistent-return': 'off',
    camelcase: 'off',
    'no-underscore-dangle': 'off',
    'no-restricted-syntax': 'off',
    'no-lonely-if': 'off',
    'default-case': 'off',
    'no-plusplus': 'off',
    'no-loop-func': 'off',
    'func-names': 'off'
  },
  parserOptions: {
    parser: 'babel-eslint',
    sourceType: 'module'
  },
  overrides: [
    {
      files: [
        '**/__tests__/*.{j,t}s?(x)',
        '**/tests/unit/**/*.spec.{j,t}s?(x)'
      ],
      env: {
        jest: true
      }
    }
  ]
}
