module.exports = {
  chainWebpack: (config) => {
    config.module
      .rule("vue")
      .use("vue-loader")
      .loader("vue-loader")
      .tap((options) => {
        options["transformAssetUrls"] = {
          "b-embend": ["src", "poster"],
          video: ["src", "poster"],
          source: "src",
          track: "src",
          img: "src",
          image: "xlink:href",
          "b-img": "src",
          "b-img-lazy": ["src", "blank-src"],
          "b-card": "img-src",
          "b-card-img": "src",
          "b-card-img-lazy": ["src", "blank-src"],
          "b-carousel-slide": "img-src",
        };
        return options;
      });

    // adjusting the media rule to include vtt files
    config.module.rule("media").test(/\.(vtt|mp4|webm|ogg|mp3|wav|flac|aac)(\?.*)?$/);
    //adjusted rule for pdf files
    config.module
      .rule("pdf")
      .test(/\.pdf$/)
      .use("file-loader")
      .loader("file-loader")
      .options({
        name: "docs/[name].[hash:8].[ext]",
      });

    // adjusted rule for pdf files
    config.module
      .rule("doc")
      .test(/\.(doc|docx)$/)
      .use("file-loader")
      .loader("file-loader")
      .options({
        name: "docs/[name].[hash:8].[ext]",
      });

    // adjusted rule for txt files
    config.module
      .rule("txt")
      .test(/\.(txt)$/)
      .use("file-loader")
      .loader("file-loader")
      .options({
        name: "docs/[name].[hash:8].[ext]",
      });
  },
  //production config path
  publicPath: process.env.NODE_ENV === "production" ? "./" : "/",
  pluginOptions: {
    i18n: {
      locale: "fr",
      fallbackLocale: "fr",
      localeDir: "locales",
      enableInSFC: false,
    },
  },
};
