<?php

namespace local_passerelle\task;

class extract_grades extends \core\task\scheduled_task {

    public function testns() {
        return 'ok!';
    }
    
    public function get_name() {
        return 'Extraire les nouvelles notes';
    }

    public function execute() {
        global $CFG;
        require_once($CFG->dirroot .'/grade/export/cad/grade_export_cad.php');

        // Un décallage d'une minute permet au tuteur d'avoir un certain temps pour corriger une faute de frappe dans
        // la note ou le commentaire.
        $current_start_time = time() - 60;
        $previous_start_time = get_config('local_passerelle', 'cron_last_start');

        //syslog(LOG_DEBUG, "Début extract_grades.execute() : $previous_start_time :: $current_start_time");

        $semaphore = get_config('local_passerelle', 'cron_semaphore');
        if ($semaphore) {
            $msg = "extract_grades.execute() en cours depuis ". date('Y-m-d h:i:s', $previous_start_time);
            //syslog(LOG_DEBUG, $msg);
            debugging($msg);
            error_log($msg);

            set_config('cron_semaphore', '', 'local_passerelle');
        }

        set_config('cron_semaphore', $current_start_time, 'local_passerelle');
        set_config('cron_last_start', $current_start_time, 'local_passerelle');

        $gec = new \grade_export_cad();
        $gec->export_grades($previous_start_time, $current_start_time);

        set_config('cron_semaphore', '', 'local_passerelle');
    }

}
