<?php

namespace local_passerelle\task;

class send_grades extends \core\task\scheduled_task {

    public function get_name() {
        return 'Envoyer les notes au SGE';
    }

    public function execute() {
        global $DB, $CFG;

        require_once($CFG->libdir .'/xmlize.php');

        $where = "sge_id = 0";
        $grades = $DB->get_records_select('local_passerelle_transaction', $where);

        foreach ($grades as $grade) {

            $reponse = $this->saisie_note($grade->data);

            $data = simplexml_load_string($reponse, 'SimpleXMLElement', LIBXML_NOCDATA | LIBXML_NOBLANKS);
            // Tâche #4794
            if ($data === false) {
                continue;
            }
            else {

                $str_data = (string) $data[0];
                $strData = (array) simplexml_load_string($str_data);

                // TODO : Info code 3005 pour "Cahier de notes - Le délai entre deux saisies de résultat n'est pas valide."
                // Quoi faire?

                if (isset($strData['Exception'])) {
                    $grade->status = "Problème de transmission : " . $strData['Exception'];
                }

                if (isset($strData['Statut']) && $strData['Statut'] === "0") {
                    $grade->sge_id  = 111; // Le système ne retourne plus le "ric" si la note est bien reçue
                    $grade->status = "Transmise";
                }

                $grade->timemodified = time();

                try {
                    $upd = $DB->update_record('local_passerelle_transaction', $grade);
                } catch(Exception $e) {
                    debugging(var_export($e));
                }
			}
        }
    }

    /**
     * '{\"provenance\":\"M\",\"idInscriptionEtudiant\":\"565661\",\"noTuteur\":\"8055\",\"note\":63,
     *   \"commentaire\":null,\"noEvaluation\":\"1\",\"typeEvaluation\":1,
     *   \"penaliteLinguistique\":0,\"indicateurReprise\":0,\"noteSur\":100}'

     * @param $array
     */

    function buildGetParams($array) {
        $ret = '';
        foreach ($array as $key => $val) {
            switch ($key) {
                case 'idInscriptionEtudiant': $key='NoInscr';
                    break;
                case 'noTuteur': $key='NoTuteur';
                    break;
                case 'noEvaluation': $key='NoEval';
                    break;
                case 'typeEvaluation': $key='TypeEval';
                    break;
                case 'note': $key='Note';
                    break;
                case 'noteSur': $key='NoteSur';
                    break;
                case 'penalite': $key='Penalite';
                    break;
                case 'commentaire': $key='Commentaire';
                                    $val = urlencode($val);
                    break;
                case 'indicateurReprise': $key='IndReprise';
                    break;
                case 'provenance': $key='Provenance';
                    break;
                case 'dateRemise': $key='DateDepotDevoir';
                    break;

            }
            $ret .= "$key=$val&";
        }

        return substr($ret, 0, count($ret) - 2);

    }
    /*
     *
     * https://portail.cegepadistance.ca/ColNet/dc2ws.asmx/SaisiNote?SystemKey=string&InstitutionLinkKey=string&NoInscr=string&
     * NoTuteur=string&NoEval=string&TypeEval=string&Note=string&NoteSur=string&Penalite=string&Commentaire=string&IndReprise=string&Provenance=string
Voici les valeurs à utiliser pour les 2 paramètres

SystemKey : coba123,123coba
InstitutionLinkKey : 915001

     */

    function saisie_note($data) {
        global $CFG;

        $curl = curl_init();

        $array = json_decode($data,true);
        $data_coba = $this->buildGetParams($array);
        // Optional Authentication:
        //curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        //curl_setopt($curl, CURLOPT_USERPWD, "username:password");

        //echo $CFG->cobaEndPoint . $data_coba;
        //die();

        curl_setopt($curl, CURLOPT_URL, $CFG->cobaEndPoint . $data_coba);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

        $result = curl_exec($curl);

        curl_close($curl);

        return $result;
    }

}

