<?php

$functions = array(
    'cad_echo' => array(
        'classname'   => 'local_passerelle_tests',
        'methodname'  => 'sendback',
        'classpath'   => 'local/passerelle/ext_tests.php',
        'description' => 'Echo input back',
        'type'        => 'read',
    ),
    'cad_etudiant_ajouter' => array(
        'classname'   => 'local_passerelle_usagers',
        'methodname'  => 'etudiant_ajouter',
        'classpath'   => 'local/passerelle/ext_usagers.php',
        'description' => 'Ajouter un compte étudiant',
        'type'        => 'write',
    ),
    'cad_etudiant_inscrire' => array(
        'classname'   => 'local_passerelle_inscriptions',
        'methodname'  => 'etudiant_inscrire',
        'classpath'   => 'local/passerelle/ext_inscriptions.php',
        'description' => 'Inscrire un étudiant',
        'type'        => 'write',
    ),
    'cad_inscription_etudiant_modifier' => array(
        'classname'   => 'local_passerelle_inscriptions',
        'methodname'  => 'inscription_etudiant_modifier',
        'classpath'   => 'local/passerelle/ext_inscriptions.php',
        'description' => "Modifier des params authorisé de l'inscription",
        'type'        => 'write',
    ),
    'cad_tuteur_ajouter' => array(
        'classname'   => 'local_passerelle_usagers',
        'methodname'  => 'tuteur_ajouter',
        'classpath'   => 'local/passerelle/ext_usagers.php',
        'description' => 'Créer un compte usager pour un tuteur et l\'inscrire au salon des tuteurs',
        'type'        => 'write',
    ),
    'cad_tuteur_inscrire' => array(
        'classname'   => 'local_passerelle_inscriptions',
        'methodname'  => 'tuteur_inscrire',
        'classpath'   => 'local/passerelle/ext_inscriptions.php',
        'description' => 'Inscrire un tuteur à un groupe-cours',
        'type'        => 'write',
    ),
    'cad_groupe_ajouter' => array(
        'classname'   => 'local_passerelle_external',
        'methodname'  => 'groupe_ajouter',
        'classpath'   => 'local/passerelle/externallib.php',
        'description' => "Creation d'un groupe-cours",
        'type'        => 'write',
    ),
    'cad_note_ajouter' => array(
        'classname'   => 'local_passerelle_external',
        'methodname'  => 'note_ajouter',
        'classpath'   => 'local/passerelle/externallib.php',
        'description' => "Ajout d'une note à une évaluation",
        'type'        => 'write',
    ),
    'cad_note_blanchir' => array(
        'classname'   => 'local_passerelle_external',
        'methodname'  => 'note_blanchir',
        'classpath'   => 'local/passerelle/externallib.php',
        'description' => "Blanchir une note d'une évaluation",
        'type'        => 'write',
    ),
    'cad_etudiant_ajouter_evenement' => array(
        'classname'   => 'local_passerelle_external',
        'methodname'  => 'etudiant_ajouter_evenement',
        'classpath'   => 'local/passerelle/externallib.php',
        'description' => "Création d'un token de connexion",
        'type'        => 'write',
    ),
    'cad_tuteur_evaluation' => array(
        'classname'   => 'local_passerelle_extras',
        'methodname'  => 'tuteur_evals_corriger',
        'classpath'   => 'local/passerelle/ext_extras.php',
        'description' => "Retourne les evaluations en attente de correction pour un tuteur",
        'type'        => 'write',
    ),
    'cad_tuteur_remplacer' => array(
        'classname'   => 'local_passerelle_inscriptions',
        'methodname'  => 'tuteur_remplacer',
        'classpath'   => 'local/passerelle/ext_inscriptions.php',
        'description' => "Remplacement d'un tuteur d'un cours-groupe",
        'type'        => 'write',
    ),
    'cad_etudiant_inactiver_cours' => array(
        'classname'   => 'local_passerelle_inscriptions',
        'methodname'  => 'etudiant_inactiver_cours',
        'classpath'   => 'local/passerelle/ext_inscriptions.php',
        'description' => "Inactiver l'inscription d'un étudiant a un cours",
        'type'        => 'write',
    ),
    'cad_etudiant_reactiver_cours' => array(
        'classname'   => 'local_passerelle_inscriptions',
        'methodname'  => 'etudiant_reactiver_cours',
        'classpath'   => 'local/passerelle/ext_inscriptions.php',
        'description' => "Reactive une inscription à un cours",
        'type'        => 'write',
    ),
    'cad_etudiant_ouvrir_examen' => array(
        'classname'   => 'local_passerelle_inscriptions',
        'methodname'  => 'etudiant_ouvrir_examen',
        'classpath'   => 'local/passerelle/ext_inscriptions.php',
        'description' => "Ouvrir un examen (nouveau || reprise)",
        'type'        => 'write',
    ),
    'cad_etudiant_prolonger_cours' => array(
        'classname'   => 'local_passerelle_inscriptions',
        'methodname'  => 'etudiant_prolonger_cours',
        'classpath'   => 'local/passerelle/ext_inscriptions.php',
        'description' => "Prolonger la date d'échéance ( devoir || examen)",
        'type'        => 'write',
    ),
    'cad_etudiant_terminer_cours' => array(
        'classname'   => 'local_passerelle_inscriptions',
        'methodname'  => 'etudiant_terminer_cours',
        'classpath'   => 'local/passerelle/ext_inscriptions.php',
        'description' => "Termine l'inscription d'un étudiant en supprimant tout se qui est relié à cette inscription-cours ",
        'type'        => 'write',
    ),
    'cad_usager_modifier' => array(
        'classname'   => 'local_passerelle_usagers',
        'methodname'  => 'usager_modifier',
        'classpath'   => 'local/passerelle/ext_usagers.php',
        'description' => "Modifier la table user (usernaname-codepermanent, email-courriel ...) ",
        'type'        => 'write',
    ),
    'cad_etudiant_changer_group' => array(
        'classname'   => 'local_passerelle_inscriptions',
        'methodname'  => 'etudiant_changer_group',
        'classpath'   => 'local/passerelle/ext_inscriptions.php',
        'description' => "Changer un étudiant de groupe.",
        'type'        => 'write',
    ),
    'cad_inscription_soumission_nbrdevoir' => array(
        'classname'   => 'local_passerelle_inscriptions',
        'methodname'  => 'inscription_soumission_nbrdevoir',
        'classpath'   => 'local/passerelle/ext_inscriptions.php',
        'description' => "Retourne le nombre de devoir remis d'une inscription cours-group étudiant.",
        'type'        => 'write',
    ),
    /*
    'cad_etudiant_supprimer' => array(
        'classname'   => 'local_passerelle_usagers',
        'methodname'  => 'etudiant_supprimer',
        'classpath'   => 'local/passerelle/ext_usagers.php',
        'description' => 'Supprimer un compte étudiant',
        'type'        => 'write',
    ), */
    /*
     'cad_tuteur_desinscrire' => array(
         'classname'   => 'local_passerelle_inscriptions',
         'methodname'  => 'tuteur_desinscrire',
         'classpath'   => 'local/passerelle/ext_inscriptions.php',
         'description' => 'Désinscrire un tuteur d\'un groupe-cours',
         'type'        => 'write',
     ), */
    /*
   'cad_tuteur_supprimer' => array(
       'classname'   => 'local_passerelle_usagers',
       'methodname'  => 'tuteur_supprimer',
       'classpath'   => 'local/passerelle/ext_usagers.php',
       'description' => 'Supprimer un compte tuteur',
       'type'        => 'write',
   ), */

    /*
    'cad_usager_ajouter' => array(
        'classname'   => 'local_passerelle_external',
        'methodname'  => 'usager_ajout',
        'classpath'   => 'local/passerelle/externallib.php',
        'description' => "Creation d'un usager",
        'type'        => 'write',
    ), */
    /*
       'cad_etudiant_modifier_evenement' => array(
           'classname'   => 'local_passerelle_external',
           'methodname'  => 'etudiant_modifier_evenement',
           'classpath'   => 'local/passerelle/externallib.php',
           'description' => "Création d'un token de connexion",
           'type'        => 'write',
       ), */
    /*
   'cad_usager_bloquer' => array(
      'classname'   => 'local_passerelle_usagers',
      'methodname'  => 'usager_bloquer',
      'classpath'   => 'local/passerelle/ext_usagers.php',
      'description' => 'Bloquer un compte étudiant',
      'type'        => 'write',
  ), */
    /*
    'cad_usager_debloquer' => array(
        'classname'   => 'local_passerelle_usagers',
        'methodname'  => 'usager_debloquer',
        'classpath'   => 'local/passerelle/ext_usagers.php',
        'description' => 'Bloquer un compte étudiant',
        'type'        => 'write',
    ), */

);

$services = array(
    'Service utilisés par SOCI' => array(
        'functions' => array(
            'cad_echo',
        ),
        'requiredcapability' => '',
        'restrictedusers' => 1,
        'enabled' => 1,
    ),
    'Service utilisé par la passerelle' => array(
        'functions' => array(
            'cad_echo',
          // 'cad_usager_ajouter',
            'cad_groupe_ajouter',
            'cad_note_ajouter',
        ),
        'requiredcapability' => '',
        'restrictedusers' => 1,
        'enabled' => 1,
    ),
    'Service utilisé par Merlin' => array(
        'functions' => array(
            'cad_echo',
            'cad_etudiant_ajouter',
           // 'cad_etudiant_supprimer',
            'cad_etudiant_inscrire',
            'cad_groupe_ajouter',
            'cad_note_ajouter',
            'cad_note_blanchir',
            'cad_tuteur_ajouter',
           // 'cad_tuteur_desinscrire',
            'cad_tuteur_inscrire',
           // 'cad_tuteur_supprimer',
            'cad_tuteur_remplacer',
            'cad_tuteur_evaluation',
           // 'cad_usager_bloquer',
           // 'cad_usager_debloquer',
            'cad_etudiant_ouvrir_examen',
            'cad_etudiant_prolonger_cours',
            'cad_etudiant_reactiver_cours',
            'cad_etudiant_inactiver_cours',
            'cad_etudiant_ajouter_evenement',
            //'cad_etudiant_modifier_evenement',
            'cad_etudiant_terminer_cours',
            'cad_usager_modifier',
            'cad_etudiant_changer_group',
            'cad_inscription_soumission_nbrdevoir',
            'cad_inscription_etudiant_modifier'
        ),
        'requiredcapability' => '',
        'restrictedusers' => 1,
        'enabled' => 1,
    ),
);