<?php

/**
 * @package   local_passerelle
 * @copyright 2014 Cégep à distance
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

/**
 * @param int $oldversion The old version of the module
 * @return bool
 */
function xmldb_local_passerelle_upgrade($oldversion) {
    global $CFG, $DB;

    $dbman = $DB->get_manager();

    if ($oldversion < 2015012102) {

        // Define table local_passerelle_transaction to be created.
        $table = new xmldb_table('local_passerelle_transaction');

        // Adding fields to table local_passerelle_transaction.
        $table->add_field('id', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, XMLDB_SEQUENCE, null);
        $table->add_field('grade_id', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, null, null);
        $table->add_field('sent', XMLDB_TYPE_INTEGER, '1', null, XMLDB_NOTNULL, null, '0');
        $table->add_field('status', XMLDB_TYPE_TEXT, null, null, null, null, null);
        $table->add_field('data', XMLDB_TYPE_TEXT, null, null, null, null, null);

        // Adding keys to table local_passerelle_transaction.
        $table->add_key('primary', XMLDB_KEY_PRIMARY, array('id'));

        // Conditionally launch create table for local_passerelle_transaction.
        if (!$dbman->table_exists($table)) {
            $dbman->create_table($table);
        }

        // Passerelle savepoint reached.
        upgrade_plugin_savepoint(true, 2015012102, 'local', 'passerelle');
    }

    if ($oldversion < 2015012702) {

        // Define field timecreated to be added to local_passerelle_transaction.
        $table = new xmldb_table('local_passerelle_transaction');
        
        $field = new xmldb_field('timecreated', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, null, '0', 'status');
        // Conditionally launch add field timecreated.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }
        
        $field = new xmldb_field('grade_timemodified', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, null, '0', 'timecreated');
        // Conditionally launch add field grade_timemodified.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Passerelle savepoint reached.
        upgrade_plugin_savepoint(true, 2015012702, 'local', 'passerelle');
    }

    if ($oldversion < 2015012703) {

        // Define index grade (unique) to be added to local_passerelle_transaction.
        $table = new xmldb_table('local_passerelle_transaction');
        $index = new xmldb_index('grade', XMLDB_INDEX_UNIQUE, array('grade_id', 'grade_timemodified'));

        // Conditionally launch add index grade.
        if (!$dbman->index_exists($table, $index)) {
            $dbman->add_index($table, $index);
        }

        // Passerelle savepoint reached.
        upgrade_plugin_savepoint(true, 2015012703, 'local', 'passerelle');
    }

    if ($oldversion < 2015012901) {

        // Define field sge_id to be dropped from local_passerelle_transaction.
        $table = new xmldb_table('local_passerelle_transaction');
        $field = new xmldb_field('sent');

        // Conditionally launch drop field sge_id.
        if ($dbman->field_exists($table, $field)) {
            $dbman->drop_field($table, $field);
        }

        $field = new xmldb_field('sge_id', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, null, '0', 'status');
        // Conditionally launch add field sge_id.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        $field = new xmldb_field('timemodified', XMLDB_TYPE_INTEGER, '10', null, null, null, null, 'timecreated');
        // Conditionally launch add field timemodified.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Passerelle savepoint reached.
        upgrade_plugin_savepoint(true, 2015012901, 'local', 'passerelle');
    }

    if ($oldversion < 2015012902) {

        // Define index sge_id (not unique) to be added to local_passerelle_transaction.
        $table = new xmldb_table('local_passerelle_transaction');
        $index = new xmldb_index('sge_id', XMLDB_INDEX_NOTUNIQUE, array('sge_id'));

        // Conditionally launch add index sge_id.
        if (!$dbman->index_exists($table, $index)) {
            $dbman->add_index($table, $index);
        }

        // Passerelle savepoint reached.
        upgrade_plugin_savepoint(true, 2015012902, 'local', 'passerelle');
    }

    return true;
}
