<?php
/**
 *
 * PHP Version 5.5
 * @category:
 * @license  http://opensource.org/licenses/gpl-license.php GNU Public License
 * @author: <nmoller@crosemont.qc.ca>
 * @link http://github.com/nmoller GitHub
 * 
 */

require_once(dirname(__FILE__) ."/lib.php");

class local_passerelle_extras extends local_passerelle_external_api {


    public static function tuteur_evals_corriger_parameters() {
        return new external_function_parameters(
            array(
                'codetuteur' => new external_value(PARAM_INT, "Idnumber du tuteur")
            )
        );
    }

    public static function tuteur_evals_corriger_returns() {
        return new external_value(PARAM_INT, "Nombre devaluations en attente de correction");
    }

    /**
     * On veut savoir combien d'évaluations sont en atente pour un tuteur.
     * @param $codetuteur
     * @return int
     */
    public static function tuteur_evals_corriger($codetuteur) {

        // Chercher le user id.
        global $DB;
        $tuteur = $DB->get_record('user', array('idnumber' => $codetuteur ));

        if (!$tuteur){
            throw new ws_exception("erreur_tuteur_inexistant", "Ce tuteur n'existe pas dans Moodle.");
        }

        $query = "select count(*) as tot ";
        $query .= "from {enrol_etudiant} dee ";
        $query .= "join {enrol_tuteur} det on (dee.courseid = det.courseid and dee.groupe = det.groupe) ";
        $query .= "join {assign} das on das.course = det.courseid ";
        $query .= "join {assign_submission} dass on (dass.assignment = das.id and dass.userid = dee.userid) ";
        $query .= "where (das.id, dass.userid) not in (select assignment, userid FROM {assign_grades}) and det.userid = :uid";

        $params['uid'] = $tuteur->id;

        $tAssignAttendingCorrection = $DB->get_records_sql($query, $params);
        // On cherche le total des assigns en attente de correction.

        if (!$tAssignAttendingCorrection) $tAssignAttendingCorrection = 0; // le tuteur n'a aucun submision des étudiant dans ses groupes.
        else {
            $tAssignAttendingCorrection = array_values($tAssignAttendingCorrection);
            $tAssignAttendingCorrection = (int) $tAssignAttendingCorrection[0]->tot;
        }

        $query1 =  " select count(*) as tot ";
        $query1 .= " from {enrol_etudiant} dee  ";
        $query1 .= " join {enrol_tuteur} det on (dee.courseid = det.courseid and dee.groupe = det.groupe)  ";
        $query1 .= " join {quiz} dq on dq.course = det.courseid  ";
        $query1 .= " join {quiz_attempts} dqa on (dqa.quiz = dq.id and dqa.userid = dee.userid)  ";
        $query1 .= " where dqa.state in ('finished', 'abandoned') and dqa.sumgrades is null and det.userid = :uid ";

        $tQuizAttendingCorrection = $DB->get_records_sql($query1, $params);
        // On cherche le total des assigns en attente de correction.
        if (!$tQuizAttendingCorrection) $tQuizAttendingCorrection = 0; // le tuteur n'a aucun submision des étudiant dans ses groupes.
        else {
            $tQuizAttendingCorrection = array_values($tQuizAttendingCorrection);
            $tQuizAttendingCorrection = (int) $tQuizAttendingCorrection[0]->tot;
        }

        $total = $tAssignAttendingCorrection + $tQuizAttendingCorrection;

        return $total;

    }
}

