<?php

require_once(dirname(__FILE__) ."/lib.php");

class local_passerelle_usagers extends local_passerelle_external_api {

    //////////////////////////////////////////////////////////////////
    // cad_etudiant_ajouter

    public static function etudiant_ajouter_parameters() {
        return new external_function_parameters(
            array(
                'usager' => new external_single_structure(
                    array(
                        'codepermanent' => new external_value(PARAM_TEXT, "Code permanent de l'étudiant en minuscules : abcd12345678"),
                        'idnumber'    => new external_value(PARAM_TEXT, "Numéro séquentiel de l'utilisateur dans SGE (soc_seq_no)"),
                        'prenom'      => new external_value(PARAM_TEXT, "Prénom de l'utilisateur : Réjean"),
                        'nom'         => new external_value(PARAM_TEXT, "Nom de famille de l'utilisateur : Tremblay"),
                        'courriel'    => new external_value(PARAM_TEXT, "Adresse courriel de l'utilisateur : rejean.tremblay@example.com"),
                        'langue'      => new external_value(PARAM_TEXT, "Langue de l'utilisateur : FR ou EN"),
                   )
                )
            )
         );
    }

    public static function etudiant_ajouter_returns() {
        return new external_value(PARAM_INT, "Numéro séquentiel de l'étudiant dans Moodle");
    }

    public static function etudiant_ajouter($usager) {
        if (!array_key_exists('courriel', $usager) or empty($usager['courriel'])) {
            $usager['courriel'] = 'courriel+'. $usager['codepermanent'] .'@cegepadistance.ca';
        }
        return local_passerelle_usagers::_usager_ajouter($usager['codepermanent'], $usager['idnumber'], $usager['nom'], $usager['prenom'], $usager['courriel'], $usager['langue']);
    }

    //////////////////////////////////////////////////////////////////
    // cad_etudiant_supprimer
    
    public static function etudiant_supprimer_parameters() {
        return new external_function_parameters(
            array(
                'usager' => new external_single_structure(
                    array(
                        'codepermanent' => new external_value(PARAM_TEXT, "Code permanent de l'étudiant en minuscules : abcd12345678"),
                   )
                )
            )
         );
    }

    public static function etudiant_supprimer_returns() {
        return new external_value(PARAM_INT, "Identifiant numérique Moodle de l'étudiant supprimé, ou 0 si l'opération a échoué.");
    }

    public static function etudiant_supprimer($usager) {
        // TODO
    }
    
    //////////////////////////////////////////////////////////////////
    // cad_tuteur_ajouter
    public static function tuteur_ajouter_parameters() {
        return new external_function_parameters(
            array(
                'tuteur' => new external_single_structure(
                    array(
                        'nic'         => new external_value(PARAM_ALPHANUM, "NIC (numéro id fourni par SGE)"),
                        'identifiant' => new external_value(PARAM_TEXT, "Numéro de tuteur (nombre entier), sans zéro initial"),
                        'prenom'      => new external_value(PARAM_TEXT, "Prénom de l'utilisateur : Réjean"),
                        'nom'         => new external_value(PARAM_TEXT, "Nom de famille de l'utilisateur : Tremblay"),
                        'courriel'    => new external_value(PARAM_TEXT, "Adresse courriel de l'utilisateur : rejean.tremblay@example.com"),
                        'langue'      => new external_value(PARAM_TEXT, "Langue de l'utilisateur : FR ou EN"),
                   )
                )
            )
         );
    }

    public static function tuteur_ajouter_returns() {
        return new external_value(PARAM_INT, "Numéro séquentiel du tuteur dans Moodle");
    }

    public static function tuteur_ajouter($tuteur) {

        global $DB, $CFG;
        require_once($CFG->libdir .'/enrollib.php');

        // $usager['department'] = departement du tuteur ? A ajouter...?

        ////
        // Démarrer la transaction, pour pouvoir faire un rollback en cas d'erreur...
        $transaction = $DB->start_delegated_transaction();

        if ($tuteur['courriel'] == '') {
            $tuteur['courriel'] = 'courriel+'. $tuteur['identifiant'] .'@cegepadistance.ca';
        }

        // $userid = local_passerelle_usagers::_usager_ajouter($tuteur['identifiant'], $tuteur['identifiant'], $tuteur['nom'], $tuteur['prenom'], $tuteur['courriel'], $tuteur['langue']);
        $userid = local_passerelle_usagers::_usager_ajouter($tuteur['identifiant'], $tuteur['nic'], $tuteur['nom'], $tuteur['prenom'], $tuteur['courriel'], $tuteur['langue']);

        // Tout ce qui suit sert à inscrire le tuteur dans le salon des tuteurs, dans la bonne langue.

        $debug_info = array();

        ////
        // Instancier le plugin d'inscription
        $enrol = enrol_get_plugin('manual');
        if (empty($enrol)) {
            throw new ws_exception("erreur_plugin_manquant", "Le plugin d'inscription des étudiants n'est pas activé.");
        }

        ////
        // Trouver le cours
        if ( strtolower($tuteur['langue']) != 'en' ) {
            $idnumber = 'SALON_FR';
        } else {
            $idnumber = 'SALON_EN';
        }
        $course = $DB->get_record('course', array('idnumber'=>$idnumber));
        if (!$course) {
            throw new ws_exception("erreur_cours_inexistant", "Le cours demandé ($idnumber) n'est pas présent dans Moodle");
        }
        array_push($debug_info, 'courseid:'.$course->id);

        $context = context_course::instance($course->id, IGNORE_MISSING);
        self::validate_context($context);
        require_capability('enrol/manual:enrol', $context);

        ////
        // Vérifier l'existence du rôle étudiant et la possibilité de l'assigner
        $roles = get_assignable_roles($context);

        if (!array_key_exists(local_passerelle_external_api::ROLE_ETUDIANT, $roles)) {
            throw new ws_exception("erreur_permission_insuffisante", "Permissions insuffisantes pour assigner le rôle d'étudiant.");
        }

        ////
        // Trouver l'instance du plugin d'inscription
        $enrolinstance = null;
        $enrolinstances = enrol_get_instances($course->id, true);
        foreach($enrolinstances as $courseenrolinstance) {
            if ($courseenrolinstance->enrol == 'manual') {
                $enrolinstance = $courseenrolinstance;
                break;
            }
        }
        if (empty($enrolinstance)) {
            throw new ws_exception("erreur_plugin_manquant", "Le plugin d'inscription manuelle n'est pas activé pour le salon des tuteurs!");
        }

        ////
        // Est-ce qu'il y a déjà une inscription active de cet étudiant à ce cours?
        $deja_inscrit = false;
        $ue = $DB->get_record('user_enrolments', array('enrolid'=>$enrolinstance->id, 'userid'=>$userid));
        if ($ue) {
            // TODO: finir la requête pour sortir le groupe auquel l'étudiant est inscrit.
            // En cas d'erreur, ça va aider au repérage de l'inscription qui pose problème.
            // SELECT g.name FROM groups g LEFT JOIN groups_members gm ON (g.id = gm.groupid) WHERE g.id = $group->id AND gm.userid = $student->id;
            $actif = ($ue->status ? 'inactif' : 'actif');
            $deja_inscrit = true;
            //throw new ws_exception("erreur_etudiant_deja_inscrit", "L'étudiant est déjà inscrit (user_enrolment.id : {$ue->id}, statut : $actif) à ce cours.");
        }

        ////
        // Inscrire l'utilisateur au cours
        if (!$$deja_inscrit) {
            $enrol->enrol_user($enrolinstance, $userid, local_passerelle_external_api::ROLE_ETUDIANT, time());
        }

        ////
        // Tout s'est bien passé, faire le commit de la transaction
        $transaction->allow_commit();

        if (!empty($debug_info)) {
            // var_dump($debug_info);
        }

        return $userid;
    }

    //////////////////////////////////////////////////////////////////
    // cad_tuteur_supprimer
    public static function tuteur_supprimer_parameters() {
        return new external_function_parameters(
            array(
                'tuteur' => new external_single_structure(
                    array(
                        'codetuteur'    => new external_value(PARAM_ALPHANUM, "Numéro de tuteur (nombre entier), sans zéro initial"),
                   )
                )
            )
         );
    }

    public static function tuteur_supprimer_returns() {
        return new external_value(PARAM_INT, "Identifiant numérique Moodle du tuteur supprimé, ou 0 si l'opération a échoué.");
    }

    public static function tuteur_supprimer($usager) {
        // TODO

        // tuteur_terminer_cours : Unenrol des cours sur lequels ils est un inscrit (user_enrolement)
        // user_delete
    }

    ///////////////////////////////
    // Création d'un utilisateur : routine utilisée pour les étudiants et les tuteurs
    public static function _usager_ajouter($identifiant, $idnumber, $nom, $prenom, $courriel, $langue) {
        global $CFG, $DB;
        require_once("$CFG->dirroot/user/lib.php");

        // on veut éviter l'identifiant vide
        if(empty($identifiant))
            throw new ws_exception("erreur_usager_inexistant", "L'identifiant est vide.");

        $user = new stdClass();
        $user->username = core_text::strtolower($identifiant);
        $user->idnumber = $idnumber;
        // Plusieurs noms sont entièrement en majuscules dans SOCI
        // L'appel à strtotitle améliore le résultat, mais brise des 
        // noms comme D'Amours, qui devient D'amours.
        $user->firstname = core_text::strtotitle($prenom);
        $user->lastname = core_text::strtotitle($nom);
        $user->email = $courriel;
        $user->auth = 'soci';
        $user->country = 'CA';
        $user->confirmed = 1;
        $user->mnethostid = $CFG->mnet_localhost_id;

        if ($langue == 'EN') {
            $user->lang = 'en';
        } else {
            $user->lang = 'fr';
        }

        $old_user = $DB->get_record('user', array('username'=>$user->username));
        if ($old_user) {
            $user->id = $old_user->id;
            user_update_user($user, false); // ne pas tenter de changement de mot de passe.
            return $user->id;
            // throw new ws_exception("erreur_usager_existe_deja", "L'usager {$user->username} existe déjà.");
        } else {
            return user_create_user($user, false);
        }
    }


    //////////////////////////////////////////////////////////////////
    // cad_usager_bloquer
    public static function usager_bloquer_parameters() {

        return new external_function_parameters(
            array(
                 'id_usager_sge' => new external_value(PARAM_TEXT, "Numéro séquentiel de l'utilisateur dans SGE (NIC)")
            )
        );
    }

    public static function usager_bloquer_returns() {
        return new external_value(PARAM_TEXT, "1 si l'opération réussie, ou 0 si l'opération a échoué.");
    }

    public static function usager_bloquer($id_usager_sge) {
        global $CFG, $DB;
  
        require_once("$CFG->dirroot/user/lib.php");

        $transaction = $DB->start_delegated_transaction();
        $current_user = $DB->get_record('user', array('idnumber'=>trim($id_usager_sge)));
        if(!$current_user)
            throw new ws_exception("usager_non_trouver", "L'usager est introuvable");

        $current_user->suspended = 1;
        $DB->update_record('user', $current_user);

        $transaction->allow_commit();

        return 1;
    }

    //////////////////////////////////////////////////////////////////
    // cad_usager_bloquer
    public static function usager_debloquer_parameters() {
        return new external_function_parameters(
            array(
                 'id_usager_sge' => new external_value(PARAM_TEXT, "Numéro séquentiel de l'utilisateur dans SGE (NIC)")
            )
        );
    }

    public static function usager_debloquer_returns() {
        return new external_value(PARAM_TEXT, "1 si l'opération réussie, ou 0 si l'opération a échoué.");
    }

    public static function usager_debloquer($id_usager_sge) {
        global $CFG, $DB;
        require_once("$CFG->dirroot/user/lib.php");

        $transaction = $DB->start_delegated_transaction();

        $current_user = $DB->get_record('user', array('idnumber'=>$id_usager_sge));
        if(!$current_user)
            throw new ws_exception("usager_non_trouver", "L'usager est introuvable");
        
        $current_user->suspended = 0;
        $DB->update_record('user', $current_user);

        $transaction->allow_commit();

        return 1;
    }


    /**
     * Tâche #1850 cad_etudiant_modifier.
     * On veut pouvoir modifier les paramètres de l'utilisateur.
     *
     */

    public static function usager_modifier_parameters(){
        return
            new external_function_parameters(
                array(
                    'key' => new external_value(PARAM_TEXT, "Valeur à modifier: ex courriel"),
                    'value' => new external_value(PARAM_TEXT, "Nouvelle valeur: ex newmail@test.com"),
                    'id' => new external_value(PARAM_TEXT, "NIC (numéro id fourni par SGE)")
                )
        );
    }

    public static function usager_modifier_returns(){
        return new external_value(PARAM_TEXT, "1 si l'opération réussie, ou 0 si l'opération a échoué.");
    }

    /**
     * Voir etudiant_modifier_parameters()
     * @param $key
     * @param $value
     * @param $id
     * @return string
     */
    public static function usager_modifier($key, $value, $id) {

        global $DB;

        // Pour avoir un contrôle sur la liste de paramètres modifiables
        $white_list  = array(
            'username',
            'email',
            'firstname',
            'lastname',
            'lang',
        );

        $user = $DB->get_record('user', array('idnumber'=> $id));

        if (!$user) {
            throw new ws_exception("erreur_usager_inexistant", "L'usager avec le NIC ({$id}) est introuvable");
        }

        if ((in_array($key, $white_list) ) && isset($user->$key)) {
            $user->$key = $value;

            if ($DB->update_record('user', $user)) {
                return "1: $user->id";
            }
            else {
                throw new ws_exception("erreur_base_de_donnees", "Impossible de sauvegarder la modification dans la base de données");
            }
        } else {
            throw new ws_exception("Une erreur s'est produite;paramètres invalides");
        }

    }

}
