<?php

require_once(dirname(__FILE__) ."/lib.php");

class local_passerelle_external extends local_passerelle_external_api {

    //////////////////////////////////////////////////////////////////
    // cad_groupe_ajouter

    public static function groupe_ajouter_parameters() {
        return new external_function_parameters(
            array(
                'groupe' => new external_single_structure(
                    array(
                        'cours'   => new external_value(PARAM_TEXT, "Cours en majuscules sans tiraits : 123123FD"),
                        'option'  => new external_value(PARAM_ALPHANUM, "Option de cours : 60"),
                        'version' => new external_value(PARAM_ALPHANUM, "Version du cours sur deux chiffres : 01"),
                        'groupe'  => new external_value(PARAM_INT, "Groupe a créer : 1-999")
                        // 'idnumber' => new external_value(PARAM_TEXT, "Identifiant unique de ce groupe"), // n'existe pas dans Merlin
                   )
                )
            )
        );
    }

    public static function groupe_ajouter_returns() {
        return new external_value(PARAM_TEXT, "Identifiant unique Moodle du groupe créé");
    }

    public static function groupe_ajouter($groupe) {
        global $CFG, $DB;
        require_once($CFG->dirroot .'/group/lib.php');
        $result = array();

        ////
        // Trouver le cours
        $num_cours = strtoupper($groupe['cours'] .'-'. $groupe['option'] .'-'. $groupe['version']);
        // TODO: confirmer qu'on utilise cours-option-version comme idnumber et pas crs_seq_no!
        $course = $DB->get_record('course', array('idnumber'=>$num_cours));
        if (!$course) {
            throw new ws_exception("erreur_cours_inexistant", "Le cours $num_cours n'est pas présent dans Moodle");
        }
        // 2. véfifier que le groupe est valide ET n'existe pas déjà
        // Trouver le groupe
        $group = groups_get_group_by_idnumber($course->id, $num_cours .'_'. $groupe['groupe']);
        if ($group) {
            //throw new ws_exception("erreur_groupe_existe_deja", "Le groupe {$groupe['groupe']} existe déjà.");
            return (int) $group->id;
        }

        // 3. créer le groupe!
        $data = new stdClass();
        $data->name = $groupe['groupe'];
        $data->idnumber = $num_cours .'_'. $groupe['groupe'];
        $data->courseid = $course->id;
        $groupeid = groups_create_group($data);
        return (int) $groupeid;
    }

    //////////////////////////////////////////////////////////////////
    // cad_note_ajouter

    public static function note_ajouter_parameters() {
        return new external_function_parameters(
            array(
                'note' => new external_single_structure(
                    array(
                        'inscription' => new external_value(PARAM_INT, "Identifiant de l'inscription (inc_seq_no) : 123456"),
                        'evalno' => new external_value(PARAM_INT, "Numéro d'évaluation : [1-7] pour les devoirs et de [1-2] pour les examens : 1 (écrit) 2 (orale) "),
                        'evaltype' => new external_value(PARAM_INT, "Type d'évaluation : 1 (devoir) ou 2 (examen)"),
                        'note' => new external_value(PARAM_FLOAT, "Note pondérée obtenue à l'évaluation : [0.00-100]"),
                        'notesur' => new external_value(PARAM_INT, "Dénominateur de la note: [1-100]"),
						'provenance' => new external_value(PARAM_ALPHA, "Provenance de la note: [A] pour Administration, [M] pour Moodle (cela n’arrivera jamais), [N] pour numérisation (LaserFiche)"),
                        'commentaire' => new external_value(PARAM_RAW, "Commentaire du tuteur (possiblement en HTML)"),
                        'date_modif' => new external_value(PARAM_RAW, "Date/heure où la note a été modifiée (RIC_DT_NOTE) : 2015-01-27 00:00:00.000"),
                    )
                )
            )
        );
    }

    public static function note_ajouter_returns() {
        return new external_value(PARAM_INT, "Grade.id où la note a été sauvegardée");
    }

    public static function note_ajouter($note) {
        global $CFG, $DB, $USER;

        // 1. Trouver l'étudiant, le cours et la série à partir de son # d'inscription
        $enrol = $DB->get_record('enrol_etudiant', array('inc_seq_no'=>$note['inscription']), '*', MUST_EXIST);
        if (!$enrol) {
            throw new ws_exception("erreur_etudiant_non_inscrit", "L'inscription de l'étudiant est introuvable.");
        }

        // 2. Bâtir les identifiants pour retrouver l'évaluation
        switch ($note['evaltype']) {
            case '1' : // devoir
                $eval_type = 'D';
                $eval_serie = $enrol->serie_devoir;
                $grade_idnumber = $eval_type . $note['evalno'] . $eval_serie;
                break;
            case '2' : // examen
                $eval_type = 'E';
                // On cherche la serie de l'inscription de l'étudiant
                if(!ctype_alpha($enrol->serie_examen))
                    throw new ws_exception("erreur_serie_examen", "La série n'est pas encore octroyée par l'SGE.");

                $eval_serie = $enrol->serie_examen;
                $grade_idnumber = $eval_type . $note['evalno'] . $eval_serie;
                break;
            default:
                throw new ws_exception("erreur_type_inexistant", "Le type d'évaluation est invalide");
                break;
        }

        // 3. Trouver les évaluations : l'item d'abord, puis la note
        require_once($CFG->libdir .'/gradelib.php');

        $item = grade_item::fetch(array('courseid'=>$enrol->courseid, 'idnumber'=>$grade_idnumber));
        //var_dump($item);

        if (!$item) {
            throw new ws_exception("erreur_evaluation_inexistante", "L'évaluation demandée est introuvable.");
        }

        // 4. Modifier les données en place

        // Vérifier que le dénominateur est le même
        if (intval($item->grademax) != $note['notesur']) {
            $noteConvertie = ($note['note'] * intval($item->grademax)) / $note['notesur'];
            $note['note'] = number_format($noteConvertie, 2, '.', ',');
        }

        $date_modif = DateTime::createFromFormat('Y-m-d H:i:s.000', $note['date_modif']);
        if (!$date_modif) {
            throw new ws_exception("erreur_date_invalide", "La date de modification de la note est invalide.");
        }
        $date_timestamp = $date_modif->format('U'); // timestamp

        // 5. Sauvegarder tout ça dans la DB.
        $transaction = $DB->start_delegated_transaction();

        $grade = $item->get_grade($enrol->userid);

        // débarrer la note, sinon la mise à jour va échouer.
        $grade->set_locked(0);

        $author = 'SGE';
        /*if ($USER->id) {
            $author = $USER->firstname .' '. $USER->lastname;
        }*/

        $updated = $item->update_final_grade($enrol->userid, $note['note'], $author, $note['commentaire'], FORMAT_PLAIN);
        if (!$updated) {
            throw new ws_exception("erreur_base_de_donnees", "La mise à jour de la note à échouée.");
        }
        // Scénarios #4516
        else if($note['provenance']) {
            if ($grade_grades_record = $DB->get_record('grade_grades', array('id'=>$grade->id))) {
                $grade_grades_record->information = iconv("ASCII", "UTF-8//IGNORE", $note['provenance']);
                $DB->update_record('grade_grades', $grade_grades_record);
            }
        }

        $grade = $item->get_grade($enrol->userid);
        $grade->set_locked($date_timestamp);

        $transaction->allow_commit();
        
        // #3647
        if ($updated) {
            if ($note['note']==0 && $item->itemmodule=='assign') {
                
                $query = "select ag.id as agid FROM {assign_grades} ag
                     JOIN {assign} ass on ass.id = ag.assignment
                     WHERE ag.userid = :ag_userid AND ass.course = :ass_course AND ag.assignment = :ag_assignment";    
                     
                $ag_id = $DB->get_field_sql($query, array('ag_userid'=>$enrol->userid, 'ass_course'=>$item->courseid, 'ag_assignment'=>$item->iteminstance), MUST_EXIST);
                if ($ag_id) {
                    
                    if ($assign_grades_record = $DB->get_record('assign_grades', array('id'=>$ag_id))) {
                        $assign_grades_record->grade = 0;
                        $assign_grades_record->timemodified = $date_timestamp;
                        $DB->update_record('assign_grades', $assign_grades_record);
                    }
        
                }                            
            
            }
                
        }

        return $grade->id;
    }

    //////////////////////////////////////////////////////////////////
    // cad_note_blanchir by ACM

    public static function note_blanchir_parameters() {
        return new external_function_parameters(
            array(
                'note' => new external_single_structure(
                    array(
                        'inscription'   => new external_value(PARAM_INT, "Identifiant de l'inscription (inc_seq_no) : 123456"),
                        'evalno' => new external_value(PARAM_INT, "Numéro d'évaluation : [1-7] pour les devoirs et de [1-2] pour les examens : 1 (écrit) 2 (orale) "),
                        'evaltype'      => new external_value(PARAM_INT, "Type d'évaluation : 1 (devoir) ou 2 (examen)")
                    )
                )
            )
        );  
    }

    public static function note_blanchir_returns() {
        return new external_value(PARAM_BOOL, "Retourne True si le blanchiment est réalisé");
    }

    public static function note_blanchir($note) {
        global $CFG,$DB,$USER;
        
        // 1. Trouver l'étudiant, le cours et la série à partir de son # d'inscription
        $enrol = $DB->get_record('enrol_etudiant', array('inc_seq_no'=>$note['inscription']), '*', MUST_EXIST);
        if (!$enrol) {
            throw new ws_exception("erreur_etudiant_non_inscrit", "L'inscription de l'étudiant est introuvable.");
        }

        //2.Vérifier que la note à blanchir existe
        //TODO

       // 3. Bâtir les identifiants pour retrouver l'évaluation
        switch ($note['evaltype']) {
            case '1' : // devoir
                $eval_type = 'D';
                $eval_serie = $enrol->serie_devoir;
                $grade_idnumber = $eval_type . $note['evalno'] . $eval_serie;
                break;
            case '2' : // examen
                $eval_type = 'E';
                // On cherche la serie de l'inscription de l'étudiant
                if(!ctype_alpha($enrol->serie_examen))
                    throw new ws_exception("erreur_serie_examen", "La série n'est pas encore octroyée par l'SGE.");

                $eval_serie = $enrol->serie_examen;
                $grade_idnumber = $eval_type . $note['evalno'] . $eval_serie;
                break;
            default:
                throw new ws_exception("erreur_type_inexistant", "Le type d'évaluation est invalide");
                break;
        }

        // 4. Trouver les évaluations : l'item d'abord, puis la note
        require_once($CFG->libdir .'/gradelib.php');

        $item = grade_item::fetch(array('courseid'=>$enrol->courseid, 'idnumber'=>$grade_idnumber));


        if (!$item) {
            throw new ws_exception("erreur_evaluation_inexistante", "L'évaluation demandée est introuvable.");
        }

        // 5. Sauvegarder tout ça dans la DB.
        $transaction = $DB->start_delegated_transaction();
        $grade = $item->get_grade($enrol->userid);

        // 5a. Tâche #4188 - si la note a été coincée il faudra la  mettre à l'état «remise en utilisant imitation du compte de COBA»
        if ($local_passerelle_transaction_record = $DB->get_record('local_passerelle_transaction', array('grade_id'=>$grade->id, 'sge_id'=>0))) {
            $local_passerelle_transaction_record->sge_id = 423; // Note remise en utilisant imitation du compte de COBA
            $local_passerelle_transaction_record->timemodified = time();
            $DB->update_record('local_passerelle_transaction', $local_passerelle_transaction_record);
        }

        $grade->delete();
        $transaction->allow_commit();
        
        return true;  
    }



    //////////////////////////////////////////////////////////////////
    // cad_ajouter_evenement
    // fonction appelée par cad_etudiant_ajouter_evenement
    public static function etudiant_ajouter_evenement_parameters() {
        return new external_function_parameters(
            array(
                'evenement' => new external_single_structure(
                    array(
                        'inc_seq_no'        => new external_value(PARAM_TEXT,   "Identifiant de l'étudiant (inc_seq_no)"), 
                        'date_heure_debut'  => new external_value(PARAM_RAW,    "Date/heure début de l'événement"),
                        'date_heure_fin'    => new external_value(PARAM_RAW,    "Date/heure fin de l'événement"),
                        'titre'             => new external_value(PARAM_TEXT,   "Titre de l'événement"),
                        'information'       => new external_value(PARAM_TEXT,   "Information sur l'événement"),
                        'scope'             => new external_value(PARAM_INT,    "User event scope = 1 || Global event scope = 2",VALUE_OPTIONAL)
                    )
                )
            )
        );  
    }

    public static function etudiant_ajouter_evenement_returns() {
        return new external_value(PARAM_INT, "Retourne l'identifiant de l'événement ajouté");
    }

    public static function etudiant_ajouter_evenement($evenement) {
        global $CFG, $DB;
        require_once($CFG->dirroot .'/calendar/lib.php');
        require_once($CFG->libdir .'/enrollib.php');

        $ue_current_data = $DB->get_record('enrol_etudiant', array('inc_seq_no'=>$evenement['inc_seq_no']));
        if(!$ue_current_data)
            throw new ws_exception("erreur_etudiant_incseqno_inexistant", "inc_seq_no ({$evenement['inc_seq_no']}) introuvable");
            
        // on vérifie si le titre comporte la notion d'annulation telle qu'envoyée par le SGE
        // SELECT DISTINCT name FROM moodle.mdl_event WHERE name LIKE '%annul%' OR name LIKE '%cancel%';
        /*
            # name
            Évaluation finale (Annulé)
            Évaluation finale (Annulée)
            Final evaluation (Cancelled)
        */
        $annulation = false;
        if (strpos($evenement['titre'], 'Annul') !== false || strpos($evenement['titre'], 'Cancel') !== false) {
            $annulation = true;
        }
        
        if($annulation)
        {
            $query = "select u.id as userid, c.fullname as coursename from {user} u
                      join {enrol_etudiant} ee on ee.userid = u.id
                      join {course} c on c.id = ee.courseid
                      where ee.inc_seq_no = :inc_seq_no";
            $data_seq = $DB->get_record_sql($query, array('inc_seq_no'=>$evenement['inc_seq_no']));

            if ($data_seq->userid) {
                             
                // on cherche dans la table events les événements avec l'userid trouvé
                $query = "select id FROM {event} e
                          where (name='Évaluation finale' OR name='Final evaluation')
                          AND e.userid = :mdl_userid
                          AND e.timestart = (:mdl_time_start)
                          ORDER BY timemodified DESC";
                $events_id_array = $DB->get_records_sql($query, array('mdl_userid'=>$data_seq->userid, 'mdl_time_start'=>strtotime($evenement['date_heure_debut'])));

                // on cherche les id des lignes à supprimer bien que normalement, il doit y avoir une seule ligne ayant ces paramètres
                $array_id = array();
                if (is_array($events_id_array) && !empty($events_id_array))
                {
                   foreach ($events_id_array as $key => $value)
                   {
                       array_push($array_id, $key);
                   }
                   // on va modifier la dernière ligne d'évaluation finale
                   $id_a_mettre_a_jour = $array_id[0];
                }
                $coursename = $data_seq->coursename;

            }
        }

        if(isset($id_a_mettre_a_jour))
        {
            $event = calendar_event::load($id_a_mettre_a_jour);
            // SGE envoie le champ vide; on met le nom du cours pour mieux informer l'étudiant
            $event->description  = $coursename;
            $event->timeduration = 0;
        }
        else
        {
            $event = new stdClass;
            $event->description  = $evenement['information'];
            // $event->timeduration est la durée d'événement
            $event->timeduration = strtotime($evenement['date_heure_fin']) - strtotime($evenement['date_heure_debut']);
        }

        $event->name         = $evenement['titre'];
        $event->courseid     = 0; // événement n'est pas visible à tous les élèves du cours
        $event->groupid      = 0;
        $event->userid       = $ue_current_data->userid;
        $event->timestart    = strtotime($evenement['date_heure_debut']);
        $event->visible      = true;
        $event->uuid         = $evenement['inc_seq_no'];

        // commencer la transaction
        if(isset($id_a_mettre_a_jour))
        {
           $event->update();
           return $id_a_mettre_a_jour;
        }
        else
        {
           $event_result = calendar_event::create($event);
           return $event_result->id;
        }

    }


    //////////////////////////////////////////////////////////////////
    // cad_modifier_evenement by ACM
    public static function etudiant_modifier_evenement_parameters() {
        return new external_function_parameters(
            array(
                'evenement' => new external_single_structure(
                    array(
                        'id_evenement_lms'  => new external_value(PARAM_INT,    "Identifiant du LMS(moodle) de l'événement - int"), 
                        'date_heure_debut'  => new external_value(PARAM_RAW,    "Date/heure début de l'événement",VALUE_OPTIONAL),
                        'date_heure_fin'    => new external_value(PARAM_RAW,    "Date/heure fin de l'événement",VALUE_OPTIONAL),
                        'titre'             => new external_value(PARAM_TEXT,   "Titre de l'événement",VALUE_OPTIONAL),
                        'information'       => new external_value(PARAM_TEXT,   "Information sur l'événement",VALUE_OPTIONAL),
                        'scope'             => new external_value(PARAM_INT,    "User event scope = 1 || Global event scope = 2",VALUE_OPTIONAL)
                    )
                )
            )
        );  
    }

    public static function etudiant_modifier_evenement_returns() {
        return new external_value(PARAM_INT, "Retourne l'identifiant de l'événement à jour (id_evenement_lms)");
    }

    public static function etudiant_modifier_evenement($evenement) {
        global $CFG, $DB;
        require($CFG->dirroot .'/calendar/lib.php');
        require_once($CFG->libdir .'/enrollib.php');
    
        // https://docs.moodle.org/dev/Calendar_API
      
        // Vérifier si l'événement existe      
        $event = calendar_event::load($evenement['id_evenement_lms']);
        if(!$event)
            throw new ws_exception("erreur_evenement_non_existant_err1", "id_evenement_lms non trouvé.");
     
        // Vérifier si l'utilisateur dans le cas ou l'événement est de type 'USER' (User event - scope = 1)
        // ... pas pour le moment - tic tac


        if (isset($evenement['date_heure_debut']))
            $event->timestart    = strtotime($evenement['date_heure_debut']);
        if (isset($evenement['date_heure_fin'])) 
            $event->timeduration = strtotime($evenement['date_heure_fin']);
        if (isset($evenement['information'])) 
            $event->description  = $evenement['information'];
        if (isset($evenement['titre'])) 
            $event->name         = $evenement['titre'];

        $transaction    = $DB->start_delegated_transaction();
        $event->update();
        $transaction    = $transaction->allow_commit();

        return $event->id;
    }

/*
    // EXEMPLE : SI ON VOULAIT AJOUTER PLUSIEURS GROUPES D'UN SEUL COUP
    public static function groupe_ajout_parameters() {
        return new external_function_parameters(
            array(
                'group' => new external_multiple_structure(
                    new external_single_structure(
                        array(
                            'course' => new external_value(PARAM_TEXT, "Cours dans lequel créer le groupe"),
                            'group' => new external_value(PARAM_TEXT, "Groupe a créer"),
                            'idnumber' => new external_value(PARAM_TEXT, "Identifiant unique de ce groupe"),
                       )
                    )
                )
            )
        );
    }
*/    
    
}
