<?php

require_once("$CFG->libdir/externallib.php");

class ws_exception Extends moodle_exception {
    /**
     * @param object $info contient "code" et "message", qui seront intégrés au message d'erreur
     */
    function __construct($errorstring, $errorinfo) {
        parent::__construct($errorstring, 'local_passerelle', '', $errorinfo);
    }
}

class local_passerelle_external_api extends external_api {
    // Roles
    const ROLE_TUTEUR = 4;
    const ROLE_ETUDIANT = 5;
}

/**
 *
 * @param $date format '2014-10-09' AAAA-MM-JJ
 * @param $userid
 * @param $name C'est le nom de l'évènement. pour la création on peut fixer la valeur par défaut
 * @param $description
 * @param int $courseid 0 pour user, 1 pour global, courseid pour cour
 */
function local_passerelle_add_event($date, $userid, $name, $description, $courseid=0) {
    global $CFG;

    require_once($CFG->dirroot .'/calendar/lib.php');

    $event = new stdClass();
    $event->action = 0;
    if ($courseid != 0) {
        $event->course = $courseid;
    }
    $event->courseid = $courseid;
    $event->userid = $userid;
    $event->eventtype = 'user';
    $event->modulename = 0;
    $event->instance = 0;
    $event->name = $name;
    $event->description = array(
        'text' => $description,
        'format' => '1'
    );
    $event->timeduration = 0;
    $time = strtotime($date);
    $event->timestart = $time;
    $event->repeats = 1;

    $calendar_event = new calendar_event($event);
    $calendar_event->update($calendar_event, false);
    return $calendar_event;
}

function local_passerelle_extends_navigation(global_navigation $navigation) {
    global $CFG;
    require_once($CFG->libdir .'/navigationlib.php');
    return;
    // echo '<!-- '. print_r($navigation->children->get('1')->parent->get('2'), true) .' -->';
    // $nodeCourseContent = $navigation->children->find('currentcourse')->children->get('2')->children->get('1');
    $nodeCourse = $navigation->children->find('currentcourse');
    if ($nodeCourse) {
        $nodeCourseContent = $nodeCourse->children->get('2');
        if ($nodeCourseContent) { 
            $nccc = $nodeCourseContent->children->get('1');
            // echo '<!-- '. print_r($nodeCourseContent, true) .' -->';
            $nccc->add('lkfjdsalkfjdsa', new moodle_url('/index.php'), null, null, '432432432');
        }
    }
}



/*
function passerelle_user_graded($e){
    debugging('user_graded appelé');
    return true;
}

function passerelle_grade_created($e){
    debugging('grade_created appelé');
    return true;
}
*/

