<?php

/* 
 * Copyright (C) 2014 Mathieu Petit-Clair
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

defined('MOODLE_INTERNAL') || die();
global $CFG;
require_once($CFG->dirroot . '/local/passerelle/externallib.php');
require_once($CFG->dirroot . '/local/passerelle/ext_usagers.php');
require_once($CFG->dirroot . '/local/passerelle/ext_inscriptions.php');

/**
 * @group local_passerelle_etudiant
 */
class local_passerelle_etudiant_testcase extends advanced_testcase {


    
    public function setUp() {
        // Calling parent is good, always
        parent::setUp();

        // We always need enabled WS for this testcase
        set_config('enablewebservices', '1');
    }    
    
    public function test_ajout() {
        global $DB, $USER, $CFG;

        $this->resetAfterTest(false); // pour tester le doublon, après!

        // This is the info we are going to check
        set_config('release', '2.4dev (Build: 20120823)');
        set_config('version', '2012083100.00');

        // Set current user
        $user = array();
        $user['username'] = 'johnd';
        $user['firstname'] = 'John';
        $user['lastname'] = 'Doe';
        self::setUser(self::getDataGenerator()->create_user($user));
        self::getDataGenerator()->role_assign(1, $USER->id);

        // Add a web service and token.
        $webservice = new stdClass();
        $webservice->name = 'Test web service';
        $webservice->enabled = true;
        $webservice->restrictedusers = false;
        $webservice->component = 'moodle';
        $webservice->timecreated = time();
        $webservice->downloadfiles = true;
        $webservice->uploadfiles = true;
        $externalserviceid = $DB->insert_record('external_services', $webservice);

        // Add a function to the service
        $DB->insert_record('external_services_functions', array('externalserviceid' => $externalserviceid,
            'functionname' => 'cad_etudiant_ajouter'));

        $_POST['wstoken'] = 'testtoken';
        $externaltoken = new stdClass();
        $externaltoken->token = 'testtoken';
        $externaltoken->tokentype = 0;
        $externaltoken->userid = $USER->id;
        $externaltoken->externalserviceid = $externalserviceid;
        $externaltoken->contextid = 1;
        $externaltoken->creatorid = $USER->id;
        $externaltoken->timecreated = time();
        $DB->insert_record('external_tokens', $externaltoken);
        
        $etudiant = array(
            'codepermanent' => 'abcd31129901',
            'idnumber' => 12345,
            'prenom' => 'Réjean',
            'nom' => 'Tremblay',
            'courriel' => 'rejean.tremblay@example.com',
            'langue' => 'FR'
        );
        
        $etudiant_retour = local_passerelle_usagers::etudiant_ajouter($etudiant);
        $etudiant_retour = external_api::clean_returnvalue(local_passerelle_usagers::etudiant_ajouter_returns(), $etudiant_retour);
       
        $this->assertInternalType('int', $etudiant_retour);
        
        $usager = $DB->get_record('user', array('id'=>$etudiant_retour));
        // Ce n'est pas superbe...
        $this->userIdDoublon = $usager->id;
        
        $this->assertEquals('soci', $usager->auth);
        $this->assertEquals('1', $usager->confirmed);
        $this->assertEquals($etudiant['codepermanent'], $usager->username);
        $this->assertEquals($etudiant['idnumber'], $usager->idnumber);
        $this->assertEquals($etudiant['prenom'], $usager->firstname);
        $this->assertEquals($etudiant['nom'], $usager->lastname);
        $this->assertEquals($etudiant['courriel'], $usager->email);
        $this->assertEquals('fr', $usager->lang);
    }
    
    public function test_ajout_doublon() {
        global $DB, $CFG;

        $this->resetAfterTest(false);

        $etudiant = array(
            'codepermanent' => 'abcd31129901',
            'idnumber' => 12345,
            'prenom' => 'Réjean',
            'nom' => 'Tremblay',
            'courriel' => 'rejean.tremblay@example.com',
            'langue' => 'FR'
        );

        $etudiant_retour = local_passerelle_usagers::etudiant_ajouter($etudiant);
        $etudiant_retour = external_api::clean_returnvalue(local_passerelle_usagers::etudiant_ajouter_returns(),
            $etudiant_retour);



        //$this->setExpectedException('ws_exception');
        $etudiant_retour1 = local_passerelle_usagers::etudiant_ajouter($etudiant);
        $etudiant_retour1 = external_api::clean_returnvalue(local_passerelle_usagers::etudiant_ajouter_returns(),
            $etudiant_retour);

        $this->assertEquals($etudiant_retour, $etudiant_retour1);

    }
    
    public function test_ajout_anglais() {
        global $DB, $CFG;

        $this->resetAfterTest(false);

        $etudiant = array(
            'codepermanent' => 'rtre31129901',
            'idnumber' => 12344,
            'prenom' => 'Réjean',
            'nom' => 'Tremblay',
            'courriel' => 'rejean.tremblay@example.com',
            'langue' => 'EN'
        );
        
        $etudiant_retour = local_passerelle_usagers::etudiant_ajouter($etudiant);
        $etudiant_retour = external_api::clean_returnvalue(local_passerelle_usagers::etudiant_ajouter_returns(), $etudiant_retour);
       
        $this->assertInternalType('int', $etudiant_retour);
        
        $usager = $DB->get_record('user', array('id'=>$etudiant_retour));
        $this->assertEquals('en', $usager->lang);
    }

    public function test_inscription() {
        global $DB, $CFG;

        $this->resetAfterTest(false);

        // créer le cours
        $cours = '101901FD';
        $option = 10;
        $version = '01';
        $course_data = array(
            'name' => "$cours-$option-$version &bullet; nom du cours",
            'shortname' => "$cours$option$version",
            'idnumber' => "$cours-$option-$version",
        );
        $course = self::getDataGenerator()->create_course($course_data);

        $groupeid = 1;
        require_once $CFG->dirroot . '/group/lib.php';

        //Ce qui est utilisé dans externallib::groupe_ajouter
        $groupIdNumber = $course_data['idnumber'] . '_'.$groupeid ;

        $gid = groups_create_group((object)array('name'=> $groupeid, 'idnumber' => $groupIdNumber, 'courseid'=>$course->id));

        $group = $DB->get_record('groups', array('id'=>$gid), '*', MUST_EXIST);

        $inscription = array(
            'codepermanent' => 'rtre31129901',
            'inc_seq_no' => 5000,
            'cours' => $cours,
            'option' => $option,
            'version' => $version,
            'crs_seq_no' => 4000,
            'annee' => 2014,
            'session' => 'A',
            'programme' => '300A0',
            'annee_version_pgm' => '2013',
            'date_inscription' => '2014-10-01',
            'groupe' => $groupeid,
            'date_expedition' => '2014-10-02',
            'date_confirmation' => '2014-11-03',
            'date_echeance_devoir' => '2015-01-03',
            'serie_devoir' => 'A',
            'serie_examen' => 'B',
        );

        // faire l'appel et charger les données ajoutées par le service web
        $inscription_id = local_passerelle_inscriptions::etudiant_inscrire($inscription);
        $inc = $DB->get_record('user_enrolments', array('id'=>$inscription_id), '*', MUST_EXIST);
        $inc_e = $DB->get_record('enrol_etudiant', array('inc_seq_no'=>$inscription['inc_seq_no']), '*', MUST_EXIST);

        $date_inscription = DateTime::createFromFormat('Y-m-d', $inscription['date_inscription']);
        $date_expedition = DateTime::createFromFormat('Y-m-d', $inscription['date_expedition']);
        $date_confirmation = DateTime::createFromFormat('Y-m-d', $inscription['date_confirmation']);
        $date_echeance = DateTime::createFromFormat('Y-m-d', $inscription['date_echeance_devoir']);

        // faire les tests
        $this->assertEquals($inc->status, "0");
        $this->assertEquals($inc->timestart, $date_inscription->getTimestamp());
        //$this->assertEquals($inc->timeend, $date_echeance->getTimestamp()); // ça va devoir changer!

        $this->assertEquals($inc_e->inc_seq_no, $inscription['inc_seq_no']);
        $this->assertEquals($inc_e->annee, $inscription['annee']);
        $this->assertEquals($inc_e->session, $inscription['session']);
        $this->assertEquals($inc_e->programme, $inscription['programme']);
        $this->assertEquals($inc_e->annee_version_pgm, $inscription['annee_version_pgm']);
        $this->assertEquals($inc_e->date_inscription, $date_inscription->getTimestamp());
        $this->assertEquals($inc_e->groupe, $groupeid);
        $this->assertEquals($inc_e->date_expedition, $date_expedition->getTimestamp());
        $this->assertEquals($inc_e->date_confirmation, $date_confirmation->getTimestamp());
        $this->assertEquals($inc_e->date_echeance_devoir, $date_echeance->getTimestamp());
        $this->assertEquals($inc_e->serie_devoir, $inscription['serie_devoir']);
        $this->assertEquals($inc_e->serie_examen, $inscription['serie_examen']);
    }
}
