<?php

/* 
 * Copyright (C) 2014 Mathieu Petit-Clair
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

defined('MOODLE_INTERNAL') || die();
global $CFG;
require_once($CFG->dirroot . '/local/passerelle/externallib.php');

/**
 * @group local_passerelle_groupe
 */
class local_passerelle_groupe_testcase extends advanced_testcase {
    
    public function setUp() {
        // Calling parent is good, always
        parent::setUp();

        // We always need enabled WS for this testcase
        set_config('enablewebservices', '1');
    }
    
    public function test_ajout() {
        global $DB, $USER, $CFG;

        $this->resetAfterTest(true);

        $cours = '101901FD';
        $option = 10;
        $version = '01';
        $course_data = array(
            'name' => "$cours-$option-$version &bullet; nom du cours",
            'shortname' => "$cours$option$version",
            'idnumber' => "$cours-$option-$version",
        );
        
        $course = self::getDataGenerator()->create_course($course_data);

        // Set current user
        $user = array();
        $user['username'] = 'johnd';
        $user['firstname'] = 'John';
        $user['lastname'] = 'Doe';
        self::setUser(self::getDataGenerator()->create_user($user));

        // Add a web service and token.
        $webservice = new stdClass();
        $webservice->name = 'Test web service';
        $webservice->enabled = true;
        $webservice->restrictedusers = false;
        $webservice->component = 'moodle';
        $webservice->timecreated = time();
        $webservice->downloadfiles = true;
        $webservice->uploadfiles = true;
        $externalserviceid = $DB->insert_record('external_services', $webservice);

        // Add a function to the service
        $DB->insert_record('external_services_functions', array('externalserviceid' => $externalserviceid,
            'functionname' => 'cad_groupe_ajouter'));

        $_POST['wstoken'] = 'testtoken';
        $externaltoken = new stdClass();
        $externaltoken->token = 'testtoken';
        $externaltoken->tokentype = 0;
        $externaltoken->userid = $USER->id;
        $externaltoken->externalserviceid = $externalserviceid;
        $externaltoken->contextid = 1;
        $externaltoken->creatorid = $USER->id;
        $externaltoken->timecreated = time();
        $DB->insert_record('external_tokens', $externaltoken);
        
        $groupe = array(
            'cours' => $cours,
            'option' => $option,
            'version' => $version,
            'groupe' => 654,
        );
        
        $groupe_retour = local_passerelle_external::groupe_ajouter($groupe);
        $groupe_retour = external_api::clean_returnvalue(local_passerelle_external::groupe_ajouter_returns(), $groupe_retour);

        $this->assertInternalType('string', $groupe_retour);

        $group = $DB->get_record('groups', array('id'=>$groupe_retour));

        $this->assertEquals($group->courseid, $course->id);
        $groupIdNumber = $groupe['cours'] .'-'.$groupe['option'].'-'.$groupe['version'].'_'.$groupe['groupe'];
        $this->assertEquals($group->idnumber, $groupIdNumber);
        $this->assertEquals($group->name, $groupe['groupe']);
    }

}
